<?php
/**
 * Elementor extension: 'Icon' parameter
 *
 * @package ThemeREX Addons
 * @since v2.18.4
 */

// Don't load directly
if ( ! defined( 'TRX_ADDONS_VERSION' ) ) {
	exit;
}


// Return 'icon' parameter
if ( !function_exists( 'trx_addons_get_icon_param' ) ) {
	function trx_addons_get_icon_param($name='icon', $only_socials=false, $style='') {
		$idx = $name != 'icon' ? $name : 0;
		if (trx_addons_get_setting('icons_selector') == 'internal') {
			if (empty($style)) {
				$style = $only_socials ? trx_addons_get_setting('socials_type') : trx_addons_get_setting('icons_type');
			}

			$is_edit_mode = trx_addons_elm_is_edit_mode();

			$params = array(
							$idx => array(
								'name' => $name,
								'type' => 'trx_icons',
								'label' => __( 'Icon', 'trx_addons' ),
								'label_block' => false,
								'default' => '',
								'options' => ! $is_edit_mode ? array() : trx_addons_get_list_icons($style),
								'style' => $style
							)
						);
		} else {
			$params = array(
							$idx => array(
								'name' => $name,
								'type' => \Elementor\Controls_Manager::ICON,
								'label' => __( 'Icon', 'trx_addons' ),
								'label_block' => false,
								'default' => '',
							)
						);
		}
		return apply_filters('trx_addons_filter_elementor_add_icon_param', $params, $only_socials, $style);
	}
}

// Check if icon name is from the Elementor icons
if ( !function_exists( 'trx_addons_is_elementor_icon' ) ) {
	function trx_addons_is_elementor_icon($icon) {
		$icon = trx_addons_elementor_get_settings_icon( $icon );
		return !empty($icon) && strpos($icon, 'fa ') !== false;
	}
}

// Get icon from param before and after v.2.6.0
if ( !function_exists( 'trx_addons_elementor_get_settings_icon' ) ) {
	function trx_addons_elementor_get_settings_icon( $icon ) {
		return is_array($icon)
						? ( !empty( $icon['icon'])
							? $icon['icon']
							: ''
							)
						: $icon;
	}
}

// Set icon in param before and after v.2.6.0
if ( !function_exists( 'trx_addons_elementor_set_settings_icon' ) ) {
	function trx_addons_elementor_set_settings_icon( $icon ) {
		return defined( 'ELEMENTOR_VERSION' ) && version_compare( ELEMENTOR_VERSION, '2.6.0', '>=' )
					? array( 'icon' => $icon )
					: $icon;
	}
}
