<?php
/**
 * The Header: Logo and main menu
 *
 * @package GEYA
 * @since GEYA 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js<?php
	// Class scheme_xxx need in the <html> as context for the <body>!
	echo ' scheme_' . esc_attr( geya_get_theme_option( 'color_scheme' ) );
?>">

<head>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<?php
	if ( function_exists( 'wp_body_open' ) ) {
		wp_body_open();
	} else {
		do_action( 'wp_body_open' );
	}
	do_action( 'geya_action_before_body' );
	?>

	<div class="<?php echo esc_attr( apply_filters( 'geya_filter_body_wrap_class', 'body_wrap' ) ); ?>" <?php do_action('geya_action_body_wrap_attributes'); ?>>

		<?php do_action( 'geya_action_before_page_wrap' ); ?>

		<div class="<?php echo esc_attr( apply_filters( 'geya_filter_page_wrap_class', 'page_wrap' ) ); ?>" <?php do_action('geya_action_page_wrap_attributes'); ?>>

			<?php do_action( 'geya_action_page_wrap_start' ); ?>

			<?php
			$geya_full_post_loading = ( geya_is_singular( 'post' ) || geya_is_singular( 'attachment' ) ) && geya_get_value_gp( 'action' ) == 'full_post_loading';
			$geya_prev_post_loading = ( geya_is_singular( 'post' ) || geya_is_singular( 'attachment' ) ) && geya_get_value_gp( 'action' ) == 'prev_post_loading';

			// Don't display the header elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ! $geya_full_post_loading && ! $geya_prev_post_loading ) {

				// Short links to fast access to the content, sidebar and footer from the keyboard
				?>
				<a class="geya_skip_link skip_to_content_link" href="#content_skip_link_anchor" tabindex="1"><?php esc_html_e( "Skip to content", 'geya' ); ?></a>
				<?php if ( geya_sidebar_present() ) { ?>
				<a class="geya_skip_link skip_to_sidebar_link" href="#sidebar_skip_link_anchor" tabindex="1"><?php esc_html_e( "Skip to sidebar", 'geya' ); ?></a>
				<?php } ?>
				<a class="geya_skip_link skip_to_footer_link" href="#footer_skip_link_anchor" tabindex="1"><?php esc_html_e( "Skip to footer", 'geya' ); ?></a>

				<?php
				do_action( 'geya_action_before_header' );

				// Header
				$geya_header_type = geya_get_theme_option( 'header_type' );
				if ( 'custom' == $geya_header_type && ! geya_is_layouts_available() ) {
					$geya_header_type = 'default';
				}
				get_template_part( apply_filters( 'geya_filter_get_template_part', "templates/header-" . sanitize_file_name( $geya_header_type ) ) );

				// Side menu
				if ( in_array( geya_get_theme_option( 'menu_side' ), array( 'left', 'right' ) ) ) {
					get_template_part( apply_filters( 'geya_filter_get_template_part', 'templates/header-navi-side' ) );
				}

				// Mobile menu
				get_template_part( apply_filters( 'geya_filter_get_template_part', 'templates/header-navi-mobile' ) );

				do_action( 'geya_action_after_header' );

			}
			?>

			<?php do_action( 'geya_action_before_page_content_wrap' ); ?>

			<div class="page_content_wrap<?php
				if ( geya_is_off( geya_get_theme_option( 'remove_margins' ) ) ) {
					if ( empty( $geya_header_type ) ) {
						$geya_header_type = geya_get_theme_option( 'header_type' );
					}
					if ( 'custom' == $geya_header_type && geya_is_layouts_available() ) {
						$geya_header_id = geya_get_custom_header_id();
						if ( $geya_header_id > 0 ) {
							$geya_header_meta = geya_get_custom_layout_meta( $geya_header_id );
							if ( ! empty( $geya_header_meta['margin'] ) ) {
								?> page_content_wrap_custom_header_margin<?php
							}
						}
					}
					$geya_footer_type = geya_get_theme_option( 'footer_type' );
					if ( 'custom' == $geya_footer_type && geya_is_layouts_available() ) {
						$geya_footer_id = geya_get_custom_footer_id();
						if ( $geya_footer_id ) {
							$geya_footer_meta = geya_get_custom_layout_meta( $geya_footer_id );
							if ( ! empty( $geya_footer_meta['margin'] ) ) {
								?> page_content_wrap_custom_footer_margin<?php
							}
						}
					}
				}
				do_action( 'geya_action_page_content_wrap_class', $geya_prev_post_loading );
				?>"<?php
				if ( apply_filters( 'geya_filter_is_prev_post_loading', $geya_prev_post_loading ) ) {
					?> data-single-style="<?php echo esc_attr( geya_get_theme_option( 'single_style' ) ); ?>"<?php
				}
				do_action( 'geya_action_page_content_wrap_data', $geya_prev_post_loading );
			?>>
				<?php
				do_action( 'geya_action_page_content_wrap', $geya_full_post_loading || $geya_prev_post_loading );

				// Single posts banner
				if ( apply_filters( 'geya_filter_single_post_header', geya_is_singular( 'post' ) || geya_is_singular( 'attachment' ) ) ) {
					if ( $geya_prev_post_loading ) {
						if ( geya_get_theme_option( 'posts_navigation_scroll_which_block' ) != 'article' ) {
							do_action( 'geya_action_between_posts' );
						}
					}
					// Single post thumbnail and title
					$geya_path = apply_filters( 'geya_filter_get_template_part', 'templates/single-styles/' . geya_get_theme_option( 'single_style' ) );
					if ( geya_get_file_dir( $geya_path . '.php' ) != '' ) {
						get_template_part( $geya_path );
					}
				}

				// Widgets area above page
				$geya_body_style   = geya_get_theme_option( 'body_style' );
				$geya_widgets_name = geya_get_theme_option( 'widgets_above_page' );
				$geya_show_widgets = ! geya_is_off( $geya_widgets_name ) && is_active_sidebar( $geya_widgets_name );
				if ( $geya_show_widgets ) {
					if ( 'fullscreen' != $geya_body_style ) {
						?>
						<div class="content_wrap">
							<?php
					}
					geya_create_widgets_area( 'widgets_above_page' );
					if ( 'fullscreen' != $geya_body_style ) {
						?>
						</div>
						<?php
					}
				}

				// Content area
				do_action( 'geya_action_before_content_wrap' );
				?>
				<div class="content_wrap<?php echo 'fullscreen' == $geya_body_style ? '_fullscreen' : ''; ?>">

					<?php do_action( 'geya_action_content_wrap_start' ); ?>

					<div class="content">
						<?php
						do_action( 'geya_action_page_content_start' );

						// Skip link anchor to fast access to the content from keyboard
						?>
						<a id="content_skip_link_anchor" class="geya_skip_link_anchor" href="#"></a>
						<?php
						// Single posts banner between prev/next posts
						if ( ( geya_is_singular( 'post' ) || geya_is_singular( 'attachment' ) )
							&& $geya_prev_post_loading 
							&& geya_get_theme_option( 'posts_navigation_scroll_which_block' ) == 'article'
						) {
							do_action( 'geya_action_between_posts' );
						}

						// Widgets area above content
						geya_create_widgets_area( 'widgets_above_content' );

						do_action( 'geya_action_page_content_start_text' );
