<?php
/**
 * The custom template to display the content
 *
 * Used for index/archive/search.
 *
 * @package GEYA
 * @since GEYA 1.0.50
 */

$geya_template_args = get_query_var( 'geya_template_args' );
if ( is_array( $geya_template_args ) ) {
	$geya_columns    = empty( $geya_template_args['columns'] ) ? 2 : max( 1, $geya_template_args['columns'] );
	$geya_blog_style = array( $geya_template_args['type'], $geya_columns );
} else {
	$geya_blog_style = explode( '_', geya_get_theme_option( 'blog_style' ) );
	$geya_columns    = empty( $geya_blog_style[1] ) ? 2 : max( 1, $geya_blog_style[1] );
}
$geya_blog_id       = geya_get_custom_blog_id( join( '_', $geya_blog_style ) );
$geya_blog_style[0] = str_replace( 'blog-custom-', '', $geya_blog_style[0] );
$geya_expanded      = ! geya_sidebar_present() && geya_get_theme_option( 'expand_content' ) == 'expand';
$geya_components    = ! empty( $geya_template_args['meta_parts'] )
							? ( is_array( $geya_template_args['meta_parts'] )
								? join( ',', $geya_template_args['meta_parts'] )
								: $geya_template_args['meta_parts']
								)
							: geya_array_get_keys_by_value( geya_get_theme_option( 'meta_parts' ) );
$geya_post_format   = get_post_format();
$geya_post_format   = empty( $geya_post_format ) ? 'standard' : str_replace( 'post-format-', '', $geya_post_format );

$geya_blog_meta     = geya_get_custom_layout_meta( $geya_blog_id );
$geya_custom_style  = ! empty( $geya_blog_meta['scripts_required'] ) ? $geya_blog_meta['scripts_required'] : 'none';

if ( ! empty( $geya_template_args['slider'] ) || $geya_columns > 1 || ! geya_is_off( $geya_custom_style ) ) {
	?><div class="
		<?php
		if ( ! empty( $geya_template_args['slider'] ) ) {
			echo 'slider-slide swiper-slide';
		} else {
			echo esc_attr( ( geya_is_off( $geya_custom_style ) ? 'column' : sprintf( '%1$s_item %1$s_item', $geya_custom_style ) ) . "-1_{$geya_columns}" );
		}
		?>
	">
	<?php
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
			'post_item post_item_container post_format_' . esc_attr( $geya_post_format )
					. ' post_layout_custom post_layout_custom_' . esc_attr( $geya_columns )
					. ' post_layout_' . esc_attr( $geya_blog_style[0] )
					. ' post_layout_' . esc_attr( $geya_blog_style[0] ) . '_' . esc_attr( $geya_columns )
					. ( ! geya_is_off( $geya_custom_style )
						? ' post_layout_' . esc_attr( $geya_custom_style )
							. ' post_layout_' . esc_attr( $geya_custom_style ) . '_' . esc_attr( $geya_columns )
						: ''
						)
		);
	geya_add_blog_animation( $geya_template_args );
	?>
>
	<?php
	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}
	// Custom layout
	do_action( 'geya_action_show_layout', $geya_blog_id, get_the_ID() );
	?>
</article><?php
if ( ! empty( $geya_template_args['slider'] ) || $geya_columns > 1 || ! geya_is_off( $geya_custom_style ) ) {
	?></div><?php
	// Need opening PHP-tag above just after </div>, because <div> is a inline-block element (used as column)!
}
