<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package GEYA
 * @since GEYA 1.0
 */

$geya_args = get_query_var( 'geya_logo_args' );

// Site logo
$geya_logo_type   = isset( $geya_args['type'] ) ? $geya_args['type'] : '';
$geya_logo_image  = geya_get_logo_image( $geya_logo_type );
$geya_logo_text   = geya_is_on( geya_get_theme_option( 'logo_text' ) ) ? get_bloginfo( 'name' ) : '';
$geya_logo_slogan = get_bloginfo( 'description', 'display' );
if ( ! empty( $geya_logo_image['logo'] ) || ! empty( $geya_logo_text ) ) {
	?><a class="sc_layouts_logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
		<?php
		if ( ! empty( $geya_logo_image['logo'] ) ) {
			if ( empty( $geya_logo_type ) && function_exists( 'the_custom_logo' ) && is_numeric($geya_logo_image['logo']) && (int) $geya_logo_image['logo'] > 0 ) {
				the_custom_logo();
			} else {
				$geya_attr = geya_getimagesize( $geya_logo_image['logo'] );
				echo '<img src="' . esc_url( $geya_logo_image['logo'] ) . '"'
						. ( ! empty( $geya_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $geya_logo_image['logo_retina'] ) . ' 2x"' : '' )
						. ' alt="' . esc_attr( $geya_logo_text ) . '"'
						. ( ! empty( $geya_attr[3] ) ? ' ' . wp_kses_data( $geya_attr[3] ) : '' )
						. '>';
			}
		} else {
			geya_show_layout( geya_prepare_macros( $geya_logo_text ), '<span class="logo_text">', '</span>' );
			geya_show_layout( geya_prepare_macros( $geya_logo_slogan ), '<span class="logo_slogan">', '</span>' );
		}
		?>
	</a>
	<?php
}
