<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: //codex.wordpress.org/Template_Hierarchy
 *
 * @package GEYA
 * @since GEYA 1.0
 */

$geya_template = apply_filters( 'geya_filter_get_template_part', geya_blog_archive_get_template() );

if ( ! empty( $geya_template ) && 'index' != $geya_template ) {

	get_template_part( $geya_template );

} else {

	geya_storage_set( 'blog_archive', true );

	get_header();

	if ( have_posts() ) {

		// Query params
		$geya_stickies   = is_home()
								|| ( in_array( geya_get_theme_option( 'post_type' ), array( '', 'post' ) )
									&& (int) geya_get_theme_option( 'parent_cat' ) == 0
									)
										? get_option( 'sticky_posts' )
										: false;
		$geya_post_type  = geya_get_theme_option( 'post_type' );
		$geya_args       = array(
								'blog_style'     => geya_get_theme_option( 'blog_style' ),
								'post_type'      => $geya_post_type,
								'taxonomy'       => geya_get_post_type_taxonomy( $geya_post_type ),
								'parent_cat'     => geya_get_theme_option( 'parent_cat' ),
								'posts_per_page' => geya_get_theme_option( 'posts_per_page' ),
								'sticky'         => geya_get_theme_option( 'sticky_style' ) == 'columns'
															&& is_array( $geya_stickies )
															&& count( $geya_stickies ) > 0
															&& get_query_var( 'paged' ) < 1
								);

		geya_blog_archive_start();

		do_action( 'geya_action_blog_archive_start' );

		if ( is_author() ) {
			do_action( 'geya_action_before_page_author' );
			get_template_part( apply_filters( 'geya_filter_get_template_part', 'templates/author-page' ) );
			do_action( 'geya_action_after_page_author' );
		}

		if ( geya_get_theme_option( 'show_filters' ) ) {
			do_action( 'geya_action_before_page_filters' );
			geya_show_filters( $geya_args );
			do_action( 'geya_action_after_page_filters' );
		} else {
			do_action( 'geya_action_before_page_posts' );
			geya_show_posts( array_merge( $geya_args, array( 'cat' => $geya_args['parent_cat'] ) ) );
			do_action( 'geya_action_after_page_posts' );
		}

		do_action( 'geya_action_blog_archive_end' );

		geya_blog_archive_end();

	} else {

		if ( is_search() ) {
			get_template_part( apply_filters( 'geya_filter_get_template_part', 'templates/content', 'none-search' ), 'none-search' );
		} else {
			get_template_part( apply_filters( 'geya_filter_get_template_part', 'templates/content', 'none-archive' ), 'none-archive' );
		}
	}

	get_footer();
}
